var samplePageObj = {
  // 샘플 타이틀
  title: '멀티 레코드(도서관정보)',
  subtitle: '하나의 데이터를 여러행으로 나눠서 볼 수 있는 기능에 대한 예제입니다.',
  // 샘플 설명
  desc: '일반적인 데이터 그리드는 하나의 데이터가 하나의 행으로 보여지는데 멀티 레코드 기능은 하나의 데이터를 여러 행으로 표현해서 많은 데이터를 한 번에 제공할 수 있는 기능입니다.<br/>인사 정보와 같은 복잡한 데이터를 한눈에 볼 수 있도록 하는 예제입니다.',

  init: {
    Cfg: {
      SearchMode: 2,
      MultiRecord: 1,
      FitWidth: true
    },
    Cols: [
      // 첫번째 단위데이터행(DataRow)
      [
        {
          Header: 'No',
          Name: 'SEQ',
          Align: 'Center',
          Width: 72,
          MinWidth: 50,
          RecordRowSpan: 3
        },
        {
          Header: '도서관명',
          Type: 'Text',
          Name: 'sName',
          Align: 'Center',
          Width: 150,
          RecordRowSpan: 3
        },

        {
          Header: '시도명',
          Type: 'Text',
          Name: 'sSido',
          CanEdit: 1,
          Width: 145,
          Align: 'Center'
        },
        {
          Header: '시군구명',
          Type: 'Enum',
          Name: 'sSiGunGu',
          CanEdit: 1,
          Width: 145,
          Align: 'Center',
          Enum: '|금천구|관악구|서초구|동작구',
          EnumKeys: '|1|2|3|4'
        },

        {
          Header: '대출가능권수',
          Type: 'Int',
          Name: 'sRentNum',
          Width: 100,
          CanEdit: 1,
          Align: 'Center',
          Format: '#,### 권'
        },
        {
          Header: '대출가능일수',
          Type: 'Int',
          Name: 'sRentDay',
          Width: 100,
          CanEdit: 1,
          Align: 'Center',
          Format: '#,### 일',
          RecordColSpan: 2
        },
        { Header: '대출가능일수' },

        {
          Header: '운영기관명',
          Type: 'Text',
          Name: 'sOperation',
          CanEdit: 1,
          Width: 145,
          Align: 'Center'
        },
        {
          Header: '도서관유형',
          Type: 'Enum',
          Name: 'sType',
          CanEdit: 1,
          Width: 116,
          Align: 'Center',
          Enum: '|공공도서관|작은도서관',
          EnumKeys: '|1|2'
        },
        {
          Header: '설립날짜',
          Name: 'sFDay',
          Type: 'Date',
          Format: 'yyyy/MM/dd',
          DataFormat: 'yyyy/MM/dd',
          EditFormat: 'yyyy/MM/dd',
          CanEdit: 1,
          Width: 140,
          Align: 'Center'
        },

        {
          Header: '시작',
          Name: 'sWeekdayStart',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          RecordRowSpan: 3,
          RecordHColSpan: 6,
          RecordHColTitle: '운영시각'
        },
        {
          Header: '종료',
          Name: 'sWeekdayEnd',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          CanEdit: 1,
          RecordRowSpan: 3,
          Align: 'Center'
        },
        {
          Header: '시작',
          Name: 'sSaturdayStart',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          RecordRowSpan: 3
        },
        {
          Header: '종료',
          Name: 'sSaturdayEnd',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          RecordRowSpan: 3
        },
        {
          Header: '시작',
          Name: 'sHolidayStart',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          RecordRowSpan: 3
        },
        {
          Header: '종료',
          Name: 'sHolidayEnd',
          Type: 'Date',
          Format: 'HH:mm',
          Width: 70,
          RecordRowSpan: 3
        },
        {
          Header: '휴관일',
          Type: 'Lines',
          Name: 'sClosed',
          Width: 90,
          RecordRowSpan: 3
        },

        {
          Header: '위도',
          Type: 'Float',
          Name: 'sLatitude',
          Visible: 0,
          RecordRowSpan: 3
        },
        {
          Header: '경도',
          Type: 'Float',
          Name: 'sLongitude',
          Visible: 0,
          RecordRowSpan: 3
        }
      ],

      // 두번째 단위데이터행(DataRow)
      [
        { Header: 'No' },
        { Header: '도서관명' },

        {
          Header: '소재지 도로명 주소',
          Type: 'Lines',
          Name: 'sAdress',
          RecordColSpan: 2,
          RecordRowSpan: 2
        },
        { Header: '소재지 도로명 주소' },

        {
          Header: '도서',
          Type: 'Int',
          Name: 'sBook',
          Align: 'Center',
          Format: '#,##0 권',
          RecordRowSpan: 2,
          RecordHColSpan: 3,
          RecordHColTitle: '자료수'
        },
        {
          Header: '연속간행물',
          Type: 'Int',
          Name: 'sSeries',
          Align: 'Center',
          Format: '#,##0 종',
          RecordRowSpan: 2
        },
        {
          Header: '비도서',
          Type: 'Int',
          Name: 'sNonbook',
          Align: 'Center',
          Format: '#,##0 종',
          RecordRowSpan: 2
        },

        {
          Header: '건물면적',
          Type: 'Float',
          Name: 'sArea',
          CanEdit: 1,
          Width: 145,
          Align: 'Center',
          Format: '#,##0.00 ㎡'
        },
        {
          Header: '전화번호',
          Type: 'Text',
          Name: 'sPhoneN',
          CanEdit: 1,
          Align: 'Center',
          RecordColSpan: 2
        },
        { Header: '전화번호' },

        {
          Header: '시작',
          RecordRowSpan: 2,
          RecordHColSpan: 2,
          RecordHColTitle: '평일'
        },
        { Header: '종료' },
        {
          Header: '시작',
          RecordRowSpan: 2,
          RecordHColSpan: 2,
          RecordHColTitle: '토요일'
        },
        { Header: '종료' },
        {
          Header: '시작',
          RecordRowSpan: 2,
          RecordHColSpan: 2,
          RecordHColTitle: '공휴일'
        },
        { Header: '종료' },
        { Header: '휴관일' },

        { Header: '위도' },
        { Header: '경도' }
      ],

      // 세번째 단위데이터행(DataRow)
      [
        { Header: 'No' },
        { Header: '도서관명' },

        { Header: '소재지 도로명 주소' },
        { Header: '소재지 도로명 주소' },

        { Header: '도서' },
        { Header: '연속간행물' },
        { Header: '비도서' },

        {
          Header: '홈페이지 주소',
          Type: 'Link',
          Name: 'sPagelink',
          Align: 'Center',
          CanEdit: 0,
          RecordColSpan: 3
        },
        { Header: '홈페이지 주소' },
        { Header: '홈페이지 주소' },

        { Header: '시작' },
        { Header: '종료' },
        { Header: '시작' },
        { Header: '종료' },
        { Header: '시작' },
        { Header: '종료' },
        { Header: '휴관일' },

        { Header: '위도' },
        { Header: '경도' }
      ],
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;}',

  // data
  data: [
    {
      sName: '동작어린이도서관',
      sOperation: '서울특별시 동작구청',
      sType: '공공도서관',
      sFDay: '1997/05/13',
      sSido: '서울특별시',
      sSiGunGu: '4',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 월요일, 법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 444.3,
      sPhoneN: '02-823-6750',
      sLatitude: 37.509147,
      sLongitude: 126.943434,
      sBook: 48681,
      sSeries: 35,
      sNonbook: 1149,
      sPagelink: '|http://lib.dongjak.go.kr|lib.dongjak.go.kr|_blank ',
      sAdress: '서울특별시 동작구 장승배기로16길 98',
    },
    {
      sName: '대방어린이도서관',
      sOperation: '서울특별시 동작구청',
      sType: '공공도서관',
      sFDay: '1988/05/14',
      sSido: '서울특별시',
      sSiGunGu: '4',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 월요일, 법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 391.3,
      sPhoneN: '02-813-6740',
      sLatitude: 37.502978,
      sLongitude: 126.925182,
      sBook: 25020,
      sSeries: 13,
      sNonbook: 298,
      sPagelink: '|http://lib.dongjak.go.kr|lib.dongjak.go.kr|_blank',
      sAdress: '서울특별시 동작구 대방동길 55',
    },
    {
      sName: '약수도서관',
      sOperation: '서울특별시 동작구청',
      sType: '공공도서관',
      sFDay: '2006/09/15',
      sSido: '서울특별시',
      sSiGunGu: '4',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 월요일, 법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 122.49,
      sPhoneN: '02-823-1907',
      sLatitude: 37.497851,
      sLongitude: 126.9474396,
      sBook: 32766,
      sSeries: 10,
      sNonbook: 873,
      sPagelink: '|http://lib.dongjak.go.kr|lib.dongjak.go.kr|_blank',
      sAdress: '서울특별시 동작구 양녕로22바길 64',
    },
    {
      sName: '동작샘터도서관',
      sOperation: '서울특별시 동작구청',
      sType: '작은도서관',
      sFDay: '2002/06/16',
      sSido: '서울특별시',
      sSiGunGu: '4',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 월요일, 법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 241,
      sPhoneN: '02-533-6750',
      sLatitude: 37.4883609,
      sLongitude: 126.977553,
      sBook: 25243,
      sSeries: 11,
      sNonbook: 348,
      sPagelink: '|http://lib.dongjak.go.kr|lib.dongjak.go.kr|_blank',
      sAdress: '서울특별시 동작구 동작대로29길 63-26',
    },
    {
      sName: '다울작은도서관',
      sOperation: '서울특별시 동작구청',
      sType: '작은도서관',
      sFDay: '1989/06/17',
      sSido: '서울특별시',
      sSiGunGu: '4',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 월요일, 법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 183,
      sPhoneN: '02-3473-3360',
      sLatitude: 37.4788487,
      sLongitude: 126.977553,
      sBook: 5016,
      sSeries: 7,
      sNonbook: 0,
      sPagelink: '|http://lib.dongjak.go.kr|lib.dongjak.go.kr|_blank',
      sAdress: '서울특별시 동작구 사당로20길132',
    },
    {
      sName: '서초구립반포도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '2010/08/18',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 159223,
      sRentDay: 14,
      sArea: 3591,
      sPhoneN: '02-520-8702',
      sLatitude: 37.502601,
      sLongitude: 127.012615,
      sBook: 159223,
      sSeries: 120,
      sNonbook: 29054,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 고무래로 34',
    },
    {
      sName: '서초구립내곡도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '2001/01/19',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 37717,
      sRentDay: 14,
      sArea: 1528,
      sPhoneN: '02-3461-3007',
      sLatitude: 37.452838,
      sLongitude: 127.054169,
      sBook: 37717,
      sSeries: 50,
      sNonbook: 926,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 청계산로7길 9-20',
    },
    {
      sName: '서이도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '2004/09/20',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 24930,
      sRentDay: 14,
      sArea: 364,
      sPhoneN: '02-3471-1335',
      sLatitude: 37.4920294,
      sLongitude: 127.024944,
      sBook: 24930,
      sSeries: 12,
      sNonbook: 0,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 서초대로70길 51',
    },
    {
      sName: '잠원도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '2004/12/21',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 18657,
      sRentDay: 14,
      sArea: 313,
      sPhoneN: '02-3477-8655',
      sLatitude: 37.515249,
      sLongitude: 127.013965,
      sBook: 18657,
      sSeries: 12,
      sNonbook: 0,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 나루터로 38',
    },
    {
      sName: '방배도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '1999/02/22',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 12365,
      sRentDay: 14,
      sArea: 264,
      sPhoneN: '02-3471-3993',
      sLatitude: 37.480523,
      sLongitude: 126.999079,
      sBook: 12365,
      sSeries: 12,
      sNonbook: 0,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 방배로40',
    },
    {
      sName: '서초그림책도서관',
      sOperation: '서초문화재단',
      sType: '공공도서관',
      sFDay: '2008/07/23',
      sSido: '서울특별시',
      sSiGunGu: '3',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '18:00',
      sHolidayStart: '09:00',
      sHolidayEnd: '18:00',
      sClosed: '매주월요일, 법정공휴일',
      sRentNum: 10236,
      sRentDay: 14,
      sArea: 316,
      sPhoneN: '02-3471-0995',
      sLatitude: 37.490761,
      sLongitude: 127.004639,
      sBook: 10236,
      sSeries: 12,
      sNonbook: 216,
      sPagelink: '|http://www.seocholib.or.kr|www.seocholib.or.kr|_blank',
      sAdress: '서울특별시 서초구 명달로150',
    },
    {
      sName: '금천구립가산도서관',
      sOperation: '금천문화재단',
      sType: '공공도서관',
      sFDay: '2010/06/24',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '07:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '07:00',
      sSaturdayEnd: '22:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매월 둘째,넷째 월요일/법정 공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 2215,
      sPhoneN: '02-865-6817',
      sLatitude: 37.4734924449,
      sLongitude: 126.8921280211,
      sBook: 74282,
      sSeries: 115,
      sNonbook: 8604,
      sPagelink: '|http://geumcheonlib.seoul.kr|geumcheonlib.seoul.kr|_blank',
      sAdress: '서울특별시 금천구 가산로5길 43',
    },
    {
      sName: '금천구립독산도서관',
      sOperation: '금천문화재단',
      sType: '공공도서관',
      sFDay: '2011/11/25',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '07:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '07:00',
      sSaturdayEnd: '22:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매월 첫째,셋째 월요일/법정 공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 2205,
      sPhoneN: '02-863-9544',
      sLatitude: 37.467565,
      sLongitude: 126.9081069091,
      sBook: 112521,
      sSeries: 152,
      sNonbook: 10825,
      sPagelink: '|http://geumcheonlib.seoul.kr|geumcheonlib.seoul.kr|_blank',
      sAdress: '서울특별시 금천구 독산로 54길 114',

    },
    {
      sName: '해오름작은도서관',
      sOperation: '구직영(문화체육과)',
      sType: '작은도서관',
      sFDay: '2000/02/26',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '10:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '일요일/법정공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 100.6,
      sPhoneN: '02-2104-5569',
      sLatitude: 37.4702207575,
      sLongitude: 126.8970433842,
      sBook: 8424,
      sSeries: 0,
      sNonbook: 0,
      sPagelink: '|',
      sAdress: '서울특별시 금천구 시흥대로123길 11',
    },
    {
      sName: '참새작은도서관',
      sOperation: '구직영(문화체육과)',
      sType: '작은도서관',
      sFDay: '1988/12/27',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '일요일/법정공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 262.34,
      sPhoneN: '02-2104-5765',
      sLatitude: 37.457387957,
      sLongitude: 126.8865496196,
      sBook: 5577,
      sSeries: 0,
      sNonbook: 0,
      sPagelink: '|http://geumcheonlib.seoul.kr|geumcheonlib.seoul.kr|_blank',
      sAdress: '서울특별시 금천구 한내로 69-15',
    },
    {
      sName: '미래향기작은도서관',
      sOperation: '구직영(문화체육과)',
      sType: '작은도서관',
      sFDay: '1997/05/28',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '10:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '일요일/법정공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 148.57,
      sPhoneN: '02-2104-5584',
      sLatitude: 37.46611089,
      sLongitude: 126.899737,
      sBook: 2545,
      sSeries: 0,
      sNonbook: 0,
      sPagelink: '|',
      sAdress: '서울특별시 금천구 범안로 1240-7',
    },
    {
      sName: '청개구리작은도서관',
      sOperation: '구직영(문화체육과)',
      sType: '작은도서관',
      sFDay: '1994/05/29',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '10:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '월,일요일/법정공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 104.98,
      sPhoneN: '02-2104-5606',
      sLatitude: 37.475136,
      sLongitude: 126.9031730792,
      sBook: 10804,
      sSeries: 2,
      sNonbook: 0,
      sPagelink: '|http://cafe.daum.net/greenfroglib|cafe.daum.net/greenfroglib|_blank',
      sAdress: '서울특별시 금천구 독산로 317',
    },
    {
      sName: '꿈씨어린이작은도서관',
      sOperation: '구직영(문화체육과)',
      sType: '작은도서관',
      sFDay: '2005/05/30',
      sSido: '서울특별시',
      sSiGunGu: '1',
      sWeekdayStart: '10:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '일요일/법정공휴일',
      sRentNum: 10,
      sRentDay: 14,
      sArea: 215.6,
      sPhoneN: '02-2104-5625',
      sLatitude: 37.4675545179,
      sLongitude: 126.902133,
      sBook: 16203,
      sSeries: 4,
      sNonbook: 0,
      sPagelink: '|',
      sAdress: '서울특별시 금천구 독산로232',
    },
    {
      sName: '은천동작은도서관',
      sOperation: '서울특별시 관악구청',
      sType: '공공도서관',
      sFDay: '1997/05/31',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 화요일/국가지정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 2974,
      sPhoneN: '02-877-1162',
      sLatitude: 37.485298,
      sLongitude: 126.942434,
      sBook: 44032,
      sSeries: 60,
      sNonbook: 1495,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 봉천로 33나길 30',
    },
    {
      sName: '조원작은도서관',
      sOperation: '서울특별시 관악구청',
      sType: '공공도서관',
      sFDay: '1997/06/01',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 수요일/법정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 2668,
      sPhoneN: '02-851-5571',
      sLatitude: 34.482544,
      sLongitude: 126.907773,
      sBook: 57893,
      sSeries: 62,
      sNonbook: 4748,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 조원로 12길 25',
    },
    {
      sName: '책이랑놀이랑',
      sOperation: '서울특별시 관악구청',
      sType: '작은도서관',
      sFDay: '2008/08/02',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 화요일/국가지정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 902,
      sPhoneN: '02-878-0955',
      sLatitude: 37.479992,
      sLongitude: 126.958588,
      sBook: 13106,
      sSeries: 15,
      sNonbook: 468,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 행운1길 12',
    },
    {
      sName: '관악산 詩도서관',
      sOperation: '서울특별시 관악구청',
      sType: '작은도서관',
      sFDay: '1990/06/03',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 화요일/국가지정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 2552,
      sPhoneN: '02-871-2261',
      sLatitude: 37.468116,
      sLongitude: 126.946069,
      sBook: 5901,
      sSeries: 0,
      sNonbook: 43,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 신림로 23',
    },
    {
      sName: '낙성대공원도서관',
      sOperation: '서울특별시 관악구청',
      sType: '작은도서관',
      sFDay: '1987/06/04',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 화요일/국가지정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: '',
      sPhoneN: '02-872-5575',
      sLatitude: 37.471383,
      sLongitude: 126.959727,
      sBook: 6725,
      sSeries: 14,
      sNonbook: 102,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 낙성대로 77',
    },
    {
      sName: '하난곡작은도서관',
      sOperation: '서울특별시 관악구청',
      sType: '작은도서관',
      sFDay: '1999/04/05',
      sSido: '서울특별시',
      sSiGunGu: '2',
      sWeekdayStart: '09:00',
      sWeekdayEnd: '12/31',
      sSaturdayStart: '09:00',
      sSaturdayEnd: '17:00',
      sHolidayStart: '00:00',
      sHolidayEnd: '00:00',
      sClosed: '매주 화요일/국가지정공휴일',
      sRentNum: 5,
      sRentDay: 14,
      sArea: 358,
      sPhoneN: '02-868-8994',
      sLatitude: 37.4767912,
      sLongitude: 126.919945,
      sBook: 13113,
      sSeries: 18,
      sNonbook: 678,
      sPagelink: '|http://lib.gwanak.go.kr|lib.gwanak.go.kr|_blank',
      sAdress: '서울특별시 관악구 난우10가길 20-7',
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
